/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Pattern;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.KFODUtil;
import oracle.cluster.verification.DiskInfoResultSet;
import oracle.cluster.verification.InvalidPathException;
import oracle.cluster.verification.util.XmlFilePathException;
import oracle.ops.mgmt.cluster.RemoteDirException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.RuntimeExec;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.param.UninitializedParamManagerException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.HAHomeNotFoundException;
import oracle.ops.verification.framework.util.InvalidEnvironmentException;
import oracle.ops.verification.framework.util.InvalidOUIInventoryDataException;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.OUIData;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

class sVerificationUtil {
    static final String INVENTORY_LOC_PROPERTY = "inventory_loc";
    static final String INVENTORY_XML_PATH_EXTENSION = VerificationConstants.FILE_SEPARATOR + "ContentsXML" + VerificationConstants.FILE_SEPARATOR + "inventory.xml";
    static final String ORACLE_SRVM_REMOTESHELL = "ORACLE_SRVM_REMOTESHELL";
    static final String ORACLE_SRVM_REMOTECOPY = "ORACLE_SRVM_REMOTECOPY";
    static final String SRVM_PROPERTY_REMOTESHELL = "oracle.srvm.remoteshell";
    static final String SRVM_PROPERTY_REMOTECOPY = "oracle.srvm.remotecp";
    static final String DEFAULT_SSH_LOC = "CV_DEFAULT_SSH_LOC";
    static final String DEFAULT_SCP_LOC = "CV_DEFAULT_SCP_LOC";
    static final String OS_VER_COMPAT_XML_FILENAME = "usm_oscompat.xml";
    static final String LS_C1_COMMAND = "ls -dc1 ";
    static final String NEW_LINE_STRING = "\\n";
    static final String WILD_CARD_CHARACTER = "*";
    static final String USM_DRIVER_SCRIPT = "acfsdriverstate";
    static final String STR_USMDEV_OWNER = "root";
    static final String STR_USMDEV_PERMS = "0770";
    static final String TZ_FILE_LOC = "/usr/share/zoneinfo/";
    static final String CSSDPATH = "/etc/init.d/init.cssd";
    static final String ROOT_USER = "root";
    static final String EXADATA_FILE = "/opt/oracle.cellos/ORACLE_CELL_OS_IS_SETUP";
    static final String[] ODA_FILE_ARR = new String[]{"/opt/oracle/extapi/64/liboak.1.so", "opt/oracle/extapi/64/oak/liboak.1.so"};
    static final String DEFAULT_ASM_DISKS_PRE_12C = "/dev/raw/*";
    static final String DEFAULT_ASM_DISKS_POST_12C = "/dev/sd*";
    private static final String m_asmLibInitDPath = "/etc/init.d/oracleasm";
    private static final String m_asmLibMountPath = "/dev/oracleasm";
    private static final String INVENTORY_GROUP_PROPERTY = "inst_group";
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private static String m_supportedOSName = "Linux";
    private static String[] m_supportedArchs = new String[]{"*86_64"};
    private static final String ARCH_COMMAND = "/bin/uname -m";
    private static final String XDPYINFO_COMMAND_X11R6 = "/usr/X11R6/bin/xdpyinfo";
    private static final String XDPYINFO_COMMAND = "/usr/bin/xdpyinfo";
    private static final String SUSE_PATCHLEVEL_COMMAND = "/bin/sed -n 's/\\(.*\\)PATCHLEVEL\\([ \\t]*\\)=\\([ \\t]*\\)\\([0-9]*\\)\\(.*\\)/\\4/p' /etc/SuSE-release";

    protected sVerificationUtil() {
    }

    protected String getInventoryFileLocation() throws InvalidOUIInventoryDataException {
        File configFile;
        String invCfgFilePtr = sVerificationUtil.getInventoryConfigFilePointer();
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("Inventory Config File's name is:'" + invCfgFilePtr + "'"));
        }
        if (!(configFile = new File(invCfgFilePtr)).exists()) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Inventory Config File '" + invCfgFilePtr + "'   doesn't exist"));
            }
            throw new InvalidOUIInventoryDataException(s_msgBundle.getMessage("4026", false, (Object[])new String[]{invCfgFilePtr}));
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(configFile.getAbsolutePath());
            Properties props = new Properties();
            props.load(fis);
            Enumeration<?> e = props.propertyNames();
            String propName = null;
            String propValue = null;
            while (e.hasMoreElements()) {
                propName = (String)e.nextElement();
                propValue = props.getProperty(propName);
                if (!propName.trim().equalsIgnoreCase(INVENTORY_LOC_PROPERTY)) continue;
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)(propName + "=" + propValue));
                }
                String invFileLocation = propValue + INVENTORY_XML_PATH_EXTENSION;
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("Inventory File Location is-->" + invFileLocation));
                }
                String string = invFileLocation;
                return string;
            }
        }
        catch (IOException e) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((Exception)e);
            }
            throw new InvalidOUIInventoryDataException(s_msgBundle.getMessage("4026", false, (Object[])new String[]{invCfgFilePtr}));
        }
        finally {
            block20: {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        if (!Trace.isLevelEnabled((int)5)) break block20;
                        Trace.out((Exception)e);
                    }
                }
            }
        }
        throw new InvalidOUIInventoryDataException("Property 'inventory_loc' wasn't found in inventory config file '" + invCfgFilePtr + "'");
    }

    public static String getInventoryConfigFilePointer() {
        return "/etc/oraInst.loc";
    }

    public static String getUniqueDistributionID() {
        int i;
        String[] output = null;
        String[] version_cmd_arr = new String[]{"/bin/rpm -q --qf  %{version} redhat-release", "/bin/rpm -q --qf  %{version} enterprise-release", "/bin/rpm -q --qf  %{version} oraclelinux-release", "/bin/rpm -q --qf  %{version} sles-release", "/bin/rpm -q --qf  %{version} asianux-release"};
        String[] cmd = new String[3];
        cmd[0] = "/bin/sh";
        cmd[1] = "-c";
        boolean distributionFound = false;
        for (i = 0; i < version_cmd_arr.length; ++i) {
            cmd[2] = version_cmd_arr[i];
            RuntimeExec runtimeExec = new RuntimeExec(cmd, null, null);
            runtimeExec.runCommand();
            String[] error = runtimeExec.getError();
            output = runtimeExec.getOutput();
            if (runtimeExec.getExitValue() != 0) {
                int j;
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("Non-zero exit status for cmd: " + cmd[0]));
                }
                VerificationLogData.logError(cmd[0]);
                if (output != null && output.length != 0) {
                    for (j = 0; j < output.length; ++j) {
                        VerificationLogData.logError(output[j]);
                        if (!Trace.isLevelEnabled((int)5)) continue;
                        Trace.out((String)output[j]);
                    }
                }
                if (error == null || error.length == 0) continue;
                for (j = 0; j < error.length; ++j) {
                    VerificationLogData.logError(error[j]);
                    if (!Trace.isLevelEnabled((int)5)) continue;
                    Trace.out((String)error[j]);
                }
                continue;
            }
            distributionFound = true;
            break;
        }
        if (!distributionFound) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"==== Could not retrieve unique distribution tag");
            }
            return null;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("Successfully executed command: '" + VerificationUtil.strArr2List(cmd, " ") + "'"));
        }
        if (output == null || output.length == 0 || output[0] == null || output[0].length() == 0) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Command output is empty");
            }
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Could not retrieve unique distribution tag");
            }
            return null;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("The command output is: '" + output[0] + "'"));
        }
        VerificationLogData.logInfo("DistributionID[" + i + "]:" + output[0]);
        if (i == 0) {
            if (output[0].startsWith("2")) {
                return "RH2.1AS";
            }
            if (output[0].startsWith("3")) {
                return "RHEL3";
            }
            if (output[0].startsWith("4")) {
                return "RHEL4";
            }
            if (output[0].startsWith("5")) {
                return "RHEL5";
            }
            if (output[0].startsWith("6")) {
                return "RHEL6";
            }
        } else if (i == 1) {
            if (output[0].startsWith("3")) {
                return "OEL3";
            }
            if (output[0].startsWith("4")) {
                return "OEL4";
            }
            if (output[0].startsWith("5")) {
                return "OEL5";
            }
        } else if (i == 2) {
            if (output[0].startsWith("6")) {
                return "OEL6";
            }
        } else if (i == 3) {
            if (output[0].startsWith("9")) {
                return "SUSE9";
            }
            if (output[0].startsWith("10")) {
                return "SUSE10";
            }
            if (output[0].startsWith("11")) {
                return "SUSE11";
            }
        } else if (i == 4) {
            if (output[0].startsWith("1")) {
                return "ASIANUX1";
            }
            if (output[0].startsWith("2")) {
                return "ASIANUX2";
            }
            if (output[0].startsWith("3")) {
                return "ASIANUX3";
            }
            return "RHEL4";
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"==== Could not retrieve unique distribution tag");
        }
        return null;
    }

    public static void getExecutionEnvironment() throws InvalidEnvironmentException {
        boolean bSshonly;
        String remoteCopyFileName;
        String remoteShellFileName;
        block20: {
            String fileName;
            File userFile;
            Object[] fileArg;
            remoteShellFileName = null;
            remoteCopyFileName = null;
            String val = VerificationUtil.getConfiguredValue(ORACLE_SRVM_REMOTESHELL, true);
            if (val != null && val.trim().length() != 0) {
                fileArg = new String[]{val};
                userFile = new File(val);
                fileName = userFile.getName();
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("User specified remote shell command=" + val));
                }
                if (!fileName.equals("ssh") && !fileName.equals("rsh")) {
                    throw new InvalidEnvironmentException(MessageBundle.getMessageBundle((String)"Prkc").getMessage("1042", false, fileArg));
                }
                if (!userFile.exists()) {
                    throw new InvalidEnvironmentException(s_msgBundle.getMessage("0040", true, fileArg));
                }
                if (!userFile.isFile()) {
                    throw new InvalidEnvironmentException(s_msgBundle.getMessage("0041", true, fileArg));
                }
                remoteShellFileName = fileName;
                System.setProperty(SRVM_PROPERTY_REMOTESHELL, val);
            }
            if ((val = VerificationUtil.getConfiguredValue(ORACLE_SRVM_REMOTECOPY, true)) != null && val.trim().length() != 0) {
                fileArg = new String[]{val};
                userFile = new File(val);
                fileName = userFile.getName();
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("User specified remote copy command=" + val));
                }
                if (!fileName.equals("scp") && !fileName.equals("rcp")) {
                    throw new InvalidEnvironmentException(MessageBundle.getMessageBundle((String)"Prkc").getMessage("1043", false, fileArg));
                }
                if (!userFile.exists()) {
                    throw new InvalidEnvironmentException(s_msgBundle.getMessage("0042", true, fileArg));
                }
                if (!userFile.isFile()) {
                    throw new InvalidEnvironmentException(s_msgBundle.getMessage("0051", true, fileArg));
                }
                remoteCopyFileName = fileName;
                System.setProperty(SRVM_PROPERTY_REMOTECOPY, val);
            }
            bSshonly = false;
            try {
                ParamManager pm = ParamManager.getInstance();
                bSshonly = pm.checkArgSshonly();
            }
            catch (UninitializedParamManagerException e) {
                if (!Trace.isLevelEnabled((int)5)) break block20;
                Trace.out((Exception)e);
            }
        }
        if (bSshonly) {
            if (remoteShellFileName == null || remoteShellFileName != null && remoteShellFileName.equalsIgnoreCase("ssh")) {
                if (remoteShellFileName == null) {
                    String sshLoc = VDMUtil.getDefaultSsh();
                    System.setProperty(SRVM_PROPERTY_REMOTESHELL, sshLoc);
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("==== SSH Location set as :" + sshLoc));
                    }
                }
                if (remoteCopyFileName == null || !remoteCopyFileName.equalsIgnoreCase("scp")) {
                    String scpLoc = VDMUtil.getDefaultScp();
                    System.setProperty(SRVM_PROPERTY_REMOTECOPY, scpLoc);
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("==== SCP Location set as :" + scpLoc));
                    }
                }
            } else if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"==== Ignored sshonly flag since the specified remote shell was not SSH");
            }
        }
    }

    public static String getCurrentGroup() throws InvalidEnvironmentException {
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        String curGrp = null;
        try {
            curGrp = nativeSys.getEffectiveGroup();
        }
        catch (NativeException ne2) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"getEffectiveGroup failed!");
            }
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((Exception)((Object)ne2));
            }
            throw new InvalidEnvironmentException(s_msgBundle.getMessage("9035", false));
        }
        return curGrp;
    }

    public static boolean evaluateCondition(String condition) {
        if ("OCFS".equalsIgnoreCase(condition)) {
            return sVerificationUtil.isOCFSConfigured();
        }
        if ("OCFS2".equalsIgnoreCase(condition)) {
            return sVerificationUtil.isOCFS2Configured();
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("ERROR with CONDITION handling: '" + condition + "' is NOT handled by evaluateCondition() SOSD."));
        }
        return false;
    }

    private static boolean isOCFSConfigured() {
        String ocfsConfFileStr = "/etc/ocfs.conf";
        File ocfsConfFile = new File(ocfsConfFileStr);
        return ocfsConfFile.exists();
    }

    private static boolean isOCFS2Configured() {
        String ocfs2ConfFileStr = "/etc/ocfs2/cluster.conf";
        File ocfs2ConfFile = new File(ocfs2ConfFileStr);
        return ocfs2ConfFile.exists();
    }

    public static String getPreReqXmlPath() throws XmlFilePathException {
        String xmlFile = VerificationUtil.getEnv("CV_PREREQ_XML");
        if (xmlFile == null) {
            xmlFile = System.getProperty("CV_PREREQ_XML");
        }
        return xmlFile;
    }

    public static String getCompSoftwareConfigXmlPath() throws XmlFilePathException {
        String xmlFile = VerificationUtil.getEnv("CV_SOFTWARE_XML");
        if (xmlFile == null) {
            xmlFile = System.getProperty("CV_SOFTWARE_XML");
        }
        if (xmlFile == null) {
            throw new XmlFilePathException("Unable to find the location for comp software config xml file." + VerificationConstants.LINE_SEPARATOR + "Set CV_SOFTWARE_XML environment variable to the correct location.");
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("software distribution config xml file is: '" + xmlFile + "'"));
        }
        return xmlFile;
    }

    public static String getOSVersionCompatXmlPath() {
        String xmlFile = VerificationUtil.getEnv("CV_OSVERCOMPAT_XML");
        if (xmlFile == null) {
            xmlFile = System.getProperty("CV_OSVERCOMPAT_XML");
        }
        if (xmlFile == null) {
            String s_fsep = System.getProperty("file.separator");
            String cvhome = VerificationUtil.getCVHome();
            xmlFile = cvhome + "cv" + s_fsep + "cvdata" + s_fsep + OS_VER_COMPAT_XML_FILENAME;
        }
        Trace.out((String)("====  File listing supported OS versions for USM: " + xmlFile));
        return xmlFile;
    }

    public static String getVariableValue(String name) {
        String returnValue = null;
        if ("SHELL".equalsIgnoreCase(name)) {
            String shellPath = VerificationUtil.getEnv("SHELL");
            String[] shellPathArr = shellPath.split(File.separator);
            returnValue = shellPathArr[shellPathArr.length - 1].toUpperCase();
        } else if ("PROCESSOR_NAME".equalsIgnoreCase(name)) {
            returnValue = sVerificationUtil.getProcessorName();
        } else if ("KERNEL_RELEASE".equalsIgnoreCase(name)) {
            returnValue = sVerificationUtil.getKernelRelease();
        } else if ("SUSE_PATCHLEVEL".equalsIgnoreCase(name)) {
            returnValue = sVerificationUtil.getSuSEPatchLevel();
        }
        return returnValue;
    }

    public static String getKernelRelease() {
        String[] output = null;
        String osReleaseCmd = "/bin/uname -r";
        String[] cmd = new String[]{"/bin/sh", "-c", osReleaseCmd};
        RuntimeExec runtimeExec = new RuntimeExec(cmd, null, null);
        runtimeExec.runCommand();
        String[] error = runtimeExec.getError();
        output = runtimeExec.getOutput();
        if (runtimeExec.getExitValue() != 0) {
            int j;
            VerificationLogData.logError(cmd[0]);
            Trace.out((int)5, (String)("Non-zero exit status for cmd: " + cmd[0]));
            if (output != null && output.length != 0) {
                for (j = 0; j < output.length; ++j) {
                    VerificationLogData.logError(output[j]);
                    Trace.out((int)5, (String)output[j]);
                }
            }
            if (error != null && error.length != 0) {
                for (j = 0; j < error.length; ++j) {
                    VerificationLogData.logError(error[j]);
                    Trace.out((int)5, (String)error[j]);
                }
            }
        }
        if (output == null || output.length == 0 || output[0] == null || output[0].length() == 0) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Command output is empty");
                Trace.out((String)"Could not retrieve kernel release");
            }
            return null;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("The command output is: '" + output[0] + "'"));
        }
        String osRelease = output[0];
        return osRelease;
    }

    private static String getProcessorName() {
        String osRelease = sVerificationUtil.getKernelRelease();
        String[] osReleaseTokens = osRelease.split(Pattern.quote("."));
        String osReleaseLastToken = osReleaseTokens[osReleaseTokens.length - 1];
        if (Pattern.compile("EL$", 2).matcher(osReleaseLastToken).matches()) {
            return "uniprocessor";
        }
        if (Pattern.compile("ELsmp$", 2).matcher(osReleaseLastToken).matches()) {
            return "smp";
        }
        if (Pattern.compile("ELhugemem$", 2).matcher(osReleaseLastToken).matches()) {
            return "hugemem";
        }
        if (Pattern.compile(".*xen.*", 2).matcher(osReleaseLastToken).matches()) {
            return "xen";
        }
        return osReleaseLastToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOraInventoryGroup() {
        String invCfgFilePtr = sVerificationUtil.getInventoryConfigFilePointer();
        Trace.out((String)("Inventory Config File's name is:'" + invCfgFilePtr + "'"));
        File configFile = new File(invCfgFilePtr);
        if (!configFile.exists()) {
            Trace.out((String)("Inventory Config File '" + invCfgFilePtr + "' doesn't exist"));
            ReportUtil.printError(s_msgBundle.getMessage("4025", true, (Object[])new String[]{invCfgFilePtr}));
            return null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(configFile.getAbsolutePath());
            Properties props = new Properties();
            props.load(fis);
            Enumeration<?> e = props.propertyNames();
            String propName = null;
            String propValue = null;
            while (e.hasMoreElements()) {
                propName = (String)e.nextElement();
                propValue = props.getProperty(propName);
                if (!propName.trim().equalsIgnoreCase(INVENTORY_GROUP_PROPERTY)) continue;
                Trace.out((String)("Oracle Inventory Group is-->" + propValue));
                String string = propValue.trim();
                return string;
            }
        }
        catch (IOException e) {
            Trace.out((Exception)e);
            ReportUtil.printError(s_msgBundle.getMessage("4026", false, (Object[])new String[]{invCfgFilePtr}));
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    Trace.out((Exception)e);
                }
            }
        }
        ReportUtil.printError(s_msgBundle.getMessage("4027", false, (Object[])new String[]{INVENTORY_GROUP_PROPERTY, invCfgFilePtr}));
        return null;
    }

    public String[] getDefaultDiscoveryDevice(String version) {
        if (VerificationUtil.isVersionPost(version, "12.1")) {
            if (Utils.isDevelopmentEnv()) {
                return new String[]{DEFAULT_ASM_DISKS_PRE_12C};
            }
            String defaultStr = null;
            String crsHome = VerificationUtil.getCRSHome();
            if (crsHome == null) {
                return new String[]{DEFAULT_ASM_DISKS_POST_12C};
            }
            try {
                KFODUtil kfodUtl = new KFODUtil(crsHome);
                defaultStr = kfodUtl.getASMDefaultDiscoveryString();
                return new String[]{defaultStr};
            }
            catch (CmdToolUtilException e) {
                Trace.out((String)("cmd tool didn't run " + e.getMessage()));
                return new String[]{DEFAULT_ASM_DISKS_POST_12C};
            }
        }
        return new String[]{DEFAULT_ASM_DISKS_PRE_12C};
    }

    public boolean containsWildCard(String path) {
        return path.contains(WILD_CARD_CHARACTER);
    }

    public String getFileListCommand() {
        return LS_C1_COMMAND;
    }

    public List<String> parseFileListOutput(String[] cmdOut) {
        List<String> fList = Arrays.asList(cmdOut);
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("Size of parsed output list is = " + fList.size()));
            for (int i = 0; i < fList.size(); ++i) {
                Trace.out((String)("Output " + i + " : " + fList.get(i)));
            }
        }
        return fList;
    }

    public String getUSMDriverScript() {
        return new String(USM_DRIVER_SCRIPT);
    }

    public String getUSMDeviceOwner() {
        return new String("root");
    }

    public String getDefaultUSMDevPerms() {
        return new String(STR_USMDEV_PERMS);
    }

    public static boolean checkPlatform(String osname, String osarch) {
        boolean match = false;
        for (String arch : m_supportedArchs) {
            String archRegEx = arch.replaceAll("\\*", ".*");
            if (!Pattern.matches(archRegEx = archRegEx.replaceAll("\\?", ".?"), osarch)) continue;
            match = true;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("Match = " + match));
        }
        if (osname.toUpperCase().equals(m_supportedOSName.toUpperCase()) && match) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Return value = true");
            }
            return true;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"Return value = false");
        }
        return false;
    }

    public static boolean checkPlatformOS(String osname) {
        if (osname.toUpperCase().equals(m_supportedOSName.toUpperCase())) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Return value = true");
            }
            return true;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"Return value = false");
        }
        return false;
    }

    public static String getSupportedOS() {
        return m_supportedOSName;
    }

    public static String getSupportedArch() {
        return Arrays.toString(m_supportedArchs);
    }

    public static String getCurrentOS() {
        return System.getProperty("os.name");
    }

    public static String getCurrentArch() {
        String arch = null;
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        NativeResult result = new NativeResult();
        nativeSystem.runRemoteExecCmd(ARCH_COMMAND, null, null, result);
        if (result.getStatus()) {
            String[] res = result.getResultString();
            if (res != null & res.length > 0) {
                arch = VerificationUtil.strArr2List(res, "").trim();
            } else {
                Trace.out((String)"runCmd failed to return successful status");
            }
        } else {
            Trace.out((String)"runCmd failed to return successful status");
        }
        return arch;
    }

    public static String getSuSEPatchLevel() {
        String patchLevel = null;
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        NativeResult result = new NativeResult();
        nativeSystem.runRemoteExecCmd(SUSE_PATCHLEVEL_COMMAND, null, null, result);
        if (result.getStatus()) {
            String[] res = result.getResultString();
            if (res != null & res.length > 0) {
                patchLevel = VerificationUtil.strArr2List(res, "").trim();
            } else {
                Trace.out((String)"runCmd failed to return successful status");
            }
        } else {
            Trace.out((String)"runCmd failed to return successful status");
        }
        return patchLevel;
    }

    public static void setFileDirPerm(String permStr, String fileDir) {
        String cmdToRun = "chmod " + permStr + " " + fileDir;
        try {
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(cmdToRun);
            int ret = proc.waitFor();
        }
        catch (IOException e) {
            Trace.out((Exception)e);
        }
        catch (InterruptedException e) {
            Trace.out((Exception)e);
        }
    }

    public static float getCTSSOffsetLimit() {
        float f = 1000.0f;
        return f;
    }

    public static String getHAHomeWithException() throws HAHomeNotFoundException {
        File cnfgFile;
        Object haHome = null;
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        String olrFileName = nativeSys.getOLRConfigLocation("localnode", new Version());
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("olrFileName=" + olrFileName));
        }
        if (!(cnfgFile = new File(olrFileName)).exists()) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)(olrFileName + " does not exist"));
            }
            throw new HAHomeNotFoundException(s_msgBundle.getMessage("9406", false, new Object[]{new String(olrFileName)}));
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("configFile=" + cnfgFile.getAbsolutePath()));
        }
        try {
            String olrCrsHomePropertyValue = Utils.getPropertyValue((String)cnfgFile.getAbsolutePath(), (String)"crs_home", (boolean)true);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("crs_home=" + olrCrsHomePropertyValue));
            }
            return olrCrsHomePropertyValue;
        }
        catch (FileNotFoundException fnfe) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("FileNotFoundException is caught:" + fnfe.getMessage()));
            }
            throw new HAHomeNotFoundException(fnfe.getMessage());
        }
        catch (IOException ie) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"IO Exception is caught");
            }
            throw new HAHomeNotFoundException(ie.getMessage());
        }
    }

    public static String getLoginShell() {
        String user = System.getProperty("user.name");
        String[] output = null;
        String[] error = null;
        String[] cmd = new String[]{"/bin/sh", "-c", "(/bin/cat /etc/passwd;/usr/bin/ypcat passwd)|/bin/awk -F: '{if ($1==\"" + user + "\") {print $7;exit 0;} }'"};
        Trace.out((String)("cmd[2] is: " + cmd[2]));
        RuntimeExec runtimeExec = new RuntimeExec(cmd, null, null);
        runtimeExec.runCommand();
        error = runtimeExec.getError();
        output = runtimeExec.getOutput();
        if (runtimeExec.getExitValue() != 0 || output == null || output.length == 0) {
            int j;
            VerificationLogData.logError(cmd[0]);
            if (runtimeExec.getExitValue() != 0) {
                Trace.out((int)5, (String)("Non-zero exit for cmd: " + cmd[0]));
            }
            if (output != null && output.length != 0) {
                for (j = 0; j < output.length; ++j) {
                    VerificationLogData.logError(output[j]);
                    Trace.out((int)5, (String)output[j]);
                }
            } else {
                Trace.out((int)5, (String)"output is NULL/EMPTY");
            }
            if (error != null && error.length != 0) {
                for (j = 0; j < error.length; ++j) {
                    VerificationLogData.logError(error[j]);
                    Trace.out((int)5, (String)error[j]);
                }
            }
            return null;
        }
        Trace.out((String)("Login shell for user '" + user + "' is: " + output[0]));
        return output[0];
    }

    public static boolean isUDEVSupported() {
        if (sVerificationUtil.getCurrentOS().toLowerCase().startsWith("linux")) {
            Trace.out((String)"UDEV supported on this OS");
            return true;
        }
        return false;
    }

    public static String getCRSHome(String node, Result result) {
        ErrorDescription errDesc = null;
        String inventoryFile = null;
        OUIData ouid = null;
        sVerificationUtil sVerUtil = new sVerificationUtil();
        try {
            inventoryFile = sVerUtil.getInventoryFileLocation();
            ouid = OUIData.getInstance(inventoryFile);
        }
        catch (InvalidOUIInventoryDataException e) {
            errDesc = new ErrorDescription(e.getMessage());
            result.addErrorDescription(errDesc);
            result.setStatus(2);
            ReportUtil.printError(e.getMessage());
            Trace.out((Exception)e);
            return null;
        }
        if (ouid == null) {
            Trace.out((String)"sVerificationUtil::getCRSHome(node, result): ERROR instantiating the OUIData object");
            result.setStatus(2);
            return null;
        }
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        String olrFileName = nativeSys.getOLRConfigLocation(node, new Version());
        boolean fileExist = false;
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("sVerificationUtil::olrFileName=" + olrFileName));
        }
        try {
            fileExist = nativeSys.pathExists(node, olrFileName, 2);
        }
        catch (RemoteDirException rde) {
            Trace.out((String)rde.getMessage());
        }
        if (!fileExist) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)(olrFileName + " does not exist, Hence considering pre-TB returning CRS Home of Local Node."));
            }
            result.setStatus(1);
            VerificationLogData.logInfo("ouid.CRSHome:" + ouid.getCRSHomeLocation());
            return ouid.getCRSHomeLocation();
        }
        if (!ouid.isCRSInstalledOnNode(node)) {
            Trace.out((String)("sVerificationUtil::CRS wasn't found installed  on node: " + node));
            errDesc = new ErrorDescription(s_msgBundle.getMessage("7593", false, (Object[])new String[]{node}));
            result.addErrorDescription(errDesc);
            result.setStatus(2);
            return null;
        }
        Trace.out((String)("sVerificationUtil::CRS found installed  on node: " + node));
        String olrCrsHome = null;
        olrCrsHome = sVerificationUtil.getOLRPropertyValue(node, "crs_home", result, true);
        if (VerificationUtil.isStringGood(olrCrsHome)) {
            result.setStatus(1);
        } else {
            result.setStatus(2);
        }
        VerificationLogData.logInfo("olrCRSHome:" + olrCrsHome);
        return olrCrsHome;
    }

    public static String getOLRPropertyValue(String nodeName, String propertyName, Result result, boolean ignoreCase) {
        String node = null;
        if ("localnode".equalsIgnoreCase(node)) {
            try {
                node = VerificationUtil.getLocalNodename();
            }
            catch (NodelistNotFoundException nlnfe) {
                result.addErrorDescription(new ErrorDescription(nlnfe.getMessage()));
                result.setStatus(2);
                return null;
            }
        } else {
            node = nodeName;
        }
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        String olrFileName = nativeSys.getOLRConfigLocation(node, new Version());
        boolean fileExist = false;
        try {
            fileExist = nativeSys.pathExists(node, olrFileName, 2);
        }
        catch (RemoteDirException rde) {
            Trace.out((String)rde.getMessage());
            result.addErrorDescription(new ErrorDescription(rde.getMessage()));
            result.setStatus(2);
            return null;
        }
        if (!fileExist) {
            String errMsg = s_msgBundle.getMessage("5311", true, (Object[])new String[]{olrFileName, node});
            result.addErrorDescription(new ErrorDescription(errMsg));
            result.setStatus(2);
            return null;
        }
        String olrPropertyValue = sVerificationUtil.getPropertyValue(node, olrFileName, propertyName, result, ignoreCase);
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)(propertyName + "=" + olrPropertyValue));
        }
        if (result.getStatus() != 2 && VerificationUtil.isStringGood(olrPropertyValue)) {
            result.setStatus(1);
        }
        VerificationLogData.logInfo("OLRPropterty:" + propertyName + " Value: " + olrPropertyValue);
        return olrPropertyValue;
    }

    public static String getPropertyValue(String nodeName, String cnfgFilePath, String propName, Result result, boolean ignoreCase) {
        ErrorDescription errDesc = null;
        String propValue = null;
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        String destinationFullPath = null;
        if (cnfgFilePath == null || cnfgFilePath.trim().length() == 0 || propName == null || propName.trim().length() == 0 || nodeName == null || nodeName.trim().length() == 0) {
            result.setStatus(2);
            return null;
        }
        String shortFileName = cnfgFilePath.substring(cnfgFilePath.lastIndexOf(File.separator) + 1);
        destinationFullPath = VerificationUtil.getDestLoc() + nodeName + "." + shortFileName;
        File localCnfgFileCopy = new File(destinationFullPath);
        try {
            localCnfgFileCopy.createNewFile();
        }
        catch (Exception e) {
            Trace.out((String)("Error creating file" + destinationFullPath));
            Trace.out((String)e.getMessage());
            errDesc = new ErrorDescription(s_msgBundle.getMessage("7706", false, (Object[])new String[]{destinationFullPath}));
            result.addErrorDescription(errDesc);
            result.setStatus(2);
            return null;
        }
        nativeSys.copyFile(nodeName, cnfgFilePath, "localnode", destinationFullPath);
        if (!localCnfgFileCopy.exists()) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)(destinationFullPath + " does not exist"));
            }
            errDesc = new ErrorDescription(s_msgBundle.getMessage("5311", false, (Object[])new String[]{destinationFullPath, nodeName}));
            result.addErrorDescription(errDesc);
            result.setStatus(2);
            return null;
        }
        try {
            propValue = Utils.getPropertyValue((String)localCnfgFileCopy.getAbsolutePath(), (String)propName, (boolean)ignoreCase);
        }
        catch (FileNotFoundException e) {
            errDesc = new ErrorDescription(s_msgBundle.getMessage("5311", false, (Object[])new String[]{localCnfgFileCopy.getAbsolutePath(), nodeName}));
            result.addErrorDescription(errDesc);
            result.setStatus(2);
            ReportUtil.printError(e.getMessage());
            Trace.out((Exception)e);
            return null;
        }
        catch (IOException e) {
            errDesc = new ErrorDescription(e.getMessage());
            result.addErrorDescription(errDesc);
            ReportUtil.printError(e.getMessage());
            Trace.out((Exception)e);
            result.setStatus(2);
            return null;
        }
        nativeSys.removeFile("localnode", localCnfgFileCopy.getAbsolutePath());
        VerificationLogData.logInfo("Propterty:" + propName + " Value: " + propValue);
        return propValue;
    }

    public static String getTZFileLoc() {
        return TZ_FILE_LOC;
    }

    public static String getCSSDFileLoc() {
        return CSSDPATH;
    }

    public static String[] getLdLibraryStrings() {
        String[] ldLibArray = new String[]{"LD_LIBRARY_PATH="};
        return ldLibArray;
    }

    public static boolean isAutoMountEnabled(String node) {
        Trace.out((String)"NOT SUPPORTED ON UNIX!");
        return false;
    }

    public static boolean isDisplayEnabled() {
        boolean displayEnabled = sVerificationUtil.isDisplayEnabled(XDPYINFO_COMMAND);
        if (displayEnabled) {
            return displayEnabled;
        }
        return sVerificationUtil.isDisplayEnabled(XDPYINFO_COMMAND_X11R6);
    }

    private static boolean isDisplayEnabled(String displayCheckCommand) {
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        NativeResult result = new NativeResult();
        String command = displayCheckCommand;
        nativeSystem.runRemoteExecCmd(command, null, null, result);
        if (result.getStatus()) {
            String[] res = result.getResultString();
            if (res != null & res.length > 0) {
                return true;
            }
            Trace.out((String)"DISPLAY variable is not set properly");
            return false;
        }
        Trace.out((String)"DISPLAY variable is not set properly");
        return false;
    }

    static String getLocalRootGroup() {
        String cmd = "/usr/bin/id root";
        Runtime r = Runtime.getRuntime();
        StringBuffer sb = new StringBuffer();
        try {
            int c;
            Process p = r.exec(cmd);
            InputStream is = p.getInputStream();
            while ((c = is.read()) != -1) {
                sb.append((char)c);
            }
        }
        catch (IOException e) {
            Trace.out((String)e.getMessage());
            return "Received exception " + e.getMessage();
        }
        String s = sb.toString();
        String j = s.split(" ")[1];
        return j.substring(j.indexOf(40) + 1, j.indexOf(41));
    }

    public static String getRootUsername() {
        return "root";
    }

    public static DiskInfoResultSet getDiskInfoForPath(String[] nodeList, String path) throws InvalidPathException {
        Trace.out((String)"NOT SUPPORTED ON UNIX!");
        return null;
    }

    public static boolean isExadataSystem() {
        File exaDataFile = new File(EXADATA_FILE);
        return exaDataFile.exists();
    }

    public static boolean isODASystem() {
        for (String file : ODA_FILE_ARR) {
            File oDAFile = new File(file);
            if (!oDAFile.exists()) continue;
            return true;
        }
        return false;
    }

    public static boolean isASMLibInstallConsistent(String[] nodeList, ResultSet asmLibInstallRsltSet, Vector<String> asmLibNotInstallNodes, Vector<String> operationFailedNode) {
        GlobalExecution globalExec;
        boolean result;
        Trace.out((String)"ENTRY");
        boolean isASMLibInst = false;
        if (null == nodeList || nodeList.length == 0) {
            return isASMLibInst;
        }
        if (null == asmLibInstallRsltSet) {
            asmLibInstallRsltSet = new ResultSet();
        }
        if ((result = (globalExec = new GlobalExecution()).checkFileExistence(nodeList, m_asmLibInitDPath, asmLibInstallRsltSet)) && asmLibInstallRsltSet.allSuccess()) {
            Trace.out((String)("ASMLib is found installed on all the nodes : " + VerificationUtil.strArr2List(nodeList)));
            VerificationLogData.logFine("ASMLib is found installed on all the nodes : " + VerificationUtil.strArr2List(nodeList));
            isASMLibInst = true;
        } else {
            Hashtable htInst = asmLibInstallRsltSet.getResultTable();
            Enumeration e = htInst.keys();
            while (e.hasMoreElements()) {
                String errMsg;
                String node = (String)e.nextElement();
                Result resultNode = (Result)htInst.get(node);
                if (resultNode.getStatus() == 1) {
                    Trace.out((String)("ASMLib is found installed on node (" + node + ")"));
                    VerificationLogData.logFine("ASMLib is found installed on node (" + node + ")");
                    continue;
                }
                if (resultNode.getStatus() == 3) {
                    Trace.out((String)("ASMLib not found installed on node (" + node + ")"));
                    VerificationLogData.logFine("ASMLib not found installed on node (" + node + ")");
                    asmLibNotInstallNodes.add(node);
                    errMsg = s_msgBundle.getMessage("10106", true, (Object[])new String[]{node});
                    asmLibInstallRsltSet.addErrorDescription(node, new ErrorDescription(errMsg));
                    continue;
                }
                operationFailedNode.add(node);
                Trace.out((String)("Failed to determine the status of ASMLib installation on node (" + node + ")"));
                VerificationLogData.logFine("Failed to determine the status of ASMLib installation on node (" + node + ")");
                errMsg = s_msgBundle.getMessage("10108", true, (Object[])new String[]{node});
                asmLibInstallRsltSet.addErrorDescription(node, new ErrorDescription(errMsg));
            }
            if (asmLibNotInstallNodes.size() == nodeList.length) {
                isASMLibInst = true;
                Trace.out((String)("ASMLib is not installed on any of the nodes : " + VerificationUtil.strArr2List(nodeList)));
                VerificationLogData.logFine("ASMLib is not installed on any of the nodes : " + VerificationUtil.strArr2List(nodeList));
                asmLibInstallRsltSet.clear();
                for (String node : nodeList) {
                    Result nodeResult = new Result(node);
                    nodeResult.setStatus(1);
                    asmLibInstallRsltSet.addResult(node, nodeResult);
                }
            }
        }
        Trace.out((String)"EXIT");
        return isASMLibInst;
    }

    public static boolean isASMLibConfiguredConsistently(String[] nodeList, ResultSet asmLibconfiguredRsltSet, Vector<String> asmLibNotConfiguredNodes, Vector<String> operationFailedNode) {
        Trace.out((String)"ENTRY");
        boolean isASMLibConfig = false;
        if (null == nodeList || nodeList.length == 0) {
            return isASMLibConfig;
        }
        if (null == asmLibconfiguredRsltSet) {
            asmLibconfiguredRsltSet = new ResultSet();
        }
        GlobalExecution globalExec = new GlobalExecution();
        globalExec.checkFileExistence(nodeList, m_asmLibMountPath, asmLibconfiguredRsltSet);
        if (asmLibconfiguredRsltSet.allSuccess()) {
            Trace.out((String)("ASMLib found configured on all the nodes : " + VerificationUtil.strArr2List(nodeList)));
            VerificationLogData.logFine("ASMLib found configured on all the nodes : " + VerificationUtil.strArr2List(nodeList));
            isASMLibConfig = true;
        } else {
            Hashtable htConf = asmLibconfiguredRsltSet.getResultTable();
            Enumeration e = htConf.keys();
            while (e.hasMoreElements()) {
                String errMsg;
                String node = (String)e.nextElement();
                Result resultNode = (Result)htConf.get(node);
                if (resultNode.getStatus() == 1) {
                    Trace.out((String)("ASMLib found configured on node (" + node + ")"));
                    VerificationLogData.logFine("ASMLib found configured on node (" + node + ")");
                    continue;
                }
                if (resultNode.getStatus() == 3) {
                    asmLibNotConfiguredNodes.add(node);
                    Trace.out((String)("ASMLib not found configured on node (" + node + ")"));
                    VerificationLogData.logError("ASMLib not found configured on node (" + node + ")");
                    errMsg = s_msgBundle.getMessage("10110", true, (Object[])new String[]{node});
                    asmLibconfiguredRsltSet.addErrorDescription(node, new ErrorDescription(errMsg));
                    continue;
                }
                operationFailedNode.add(node);
                Trace.out((String)("Failed to determine the status of ASMLib configuration on node (" + node + ")"));
                VerificationLogData.logError("Failed to determine the status of ASMLib configuration on node (" + node + ")");
                errMsg = s_gMsgBundle.getMessage("10120", true, (Object[])new String[]{node});
                asmLibconfiguredRsltSet.addErrorDescription(node, new ErrorDescription(errMsg));
            }
            if (asmLibNotConfiguredNodes.size() == nodeList.length) {
                isASMLibConfig = true;
                Trace.out((String)("ASMLib is not configured on any of the nodes : " + VerificationUtil.strArr2List(nodeList)));
                VerificationLogData.logFine("ASMLib is not configured on any of the nodes : " + VerificationUtil.strArr2List(nodeList));
                asmLibconfiguredRsltSet.clear();
                for (String node : nodeList) {
                    Result nodeResult = new Result(node);
                    nodeResult.setStatus(1);
                    asmLibconfiguredRsltSet.addResult(node, nodeResult);
                }
            }
        }
        Trace.out((String)"EXIT");
        return isASMLibConfig;
    }

    public static boolean isASMLibConfigured(String[] nodeList) {
        ResultSet asmLibChkRsltSet = new ResultSet();
        Vector<String> asmLibNotInstallNodes = new Vector<String>();
        Vector<String> operationFailedNodes = new Vector<String>();
        Vector<String> asmLibNotConfigNodes = new Vector<String>();
        Trace.out((String)"checking if installation is consistent");
        boolean isInstallConsistent = sVerificationUtil.isASMLibInstallConsistent(nodeList, asmLibChkRsltSet, asmLibNotInstallNodes, operationFailedNodes);
        if (!isInstallConsistent) {
            Trace.out((String)"install not consistent");
            return false;
        }
        Trace.out((String)"checking if configuration is consistent");
        asmLibChkRsltSet.clear();
        boolean isConfigConsistent = sVerificationUtil.isASMLibConfiguredConsistently(nodeList, asmLibChkRsltSet, asmLibNotConfigNodes, operationFailedNodes);
        if (isConfigConsistent && asmLibNotConfigNodes.size() > 0) {
            Trace.out((String)("ASMLib is not configured on nodes " + asmLibNotConfigNodes));
            return false;
        }
        return isConfigConsistent;
    }

    public static String getDomainSocketsDir() {
        return "/var/tmp/.oracle";
    }

    public static String getInitTabLoc() {
        return "/etc/inittab";
    }

    public static String getInitdLoc() {
        return "/etc/init.d";
    }
}

